#!/bin/bash
# Copyright 2018 BADU Networks, Inc.
#
# install using crontab as in
# * * * * * /path/to/BaduTestWatchdog.sh 9000 90001 >/dev/null 2>&1 
#

PORTA=$1
PORTB=$2

# Check parameters
if [ "$#" -ne 2 ]; then
   echo "No ports specified; using default ports of 9000 and 9001."
   echo "Usage: $0 9000 9001"  
   PORTA=9000
   PORTB=9001
fi

# Change directory to location of this script
cd $( dirname "${BASH_SOURCE[0]}" )

# Check number of running test server processes
RUNNING=$( pgrep BaduTestServer | wc -l )
# If number is correct (4), run a test against each running port
if [[ ${RUNNING} -eq 4 ]]; then
   BYTECOUNTA=$( curl --connect-timeout 15 --header "Content-Type: application/json" --request POST --data '{"download_size": 10000}' http://localhost:${PORTA}/ 2>/dev/null | wc -c )
   BYTECOUNTB=$( curl --connect-timeout 15 --header "Content-Type: application/json" --request POST --data '{"download_size": 10000}' http://localhost:${PORTB}/ 2>/dev/null | wc -c )
   BYTECOUNT=$(( $BYTECOUNTA + $BYTECOUNTB ))
else
   BYTECOUNT=0
fi

# If our curl test failed, restart test server processes
if [[ $BYTECOUNT -ne 20000 ]] ; then
   if [[ ${RUNNING} -gt 0 ]] ; then
      pgrep BaduTestServer | xargs kill -9 
      sleep 3
   fi
   nohup ./BaduTestServer ${PORTA} >/dev/null 2>&1  &
   nohup ./BaduTestServer ${PORTB} >/dev/null 2>&1  &
fi
